<?php
App::uses('AppController', 'Controller');
/**
 * CustomerNotes Controller
 *
 * @property CustomerNotes $CustomerNotes
 * @property PaginatorComponent $Paginator
 * @property SessionComponent $Session
 */
class CustomerNotesController extends AppController
{

    /**
     * Components
     *
     * @var array
     */
    public $uses = array('CustomerNotes', 'Customer', 'SalesEntry', 'Product', 'User');

    public $layout = 'admin_home';
    public $components = array('Acl', 'Contract');

    /**
     * index method
     *
     * @return void
     */
    public function beforeFilter()
    {
        parent::beforeFilter();
        $this->Auth->allow('edit_customer_note', 'other_sales_detail', 'set_payment_detail', 'download_file');
    }

    /**
     * History search and listing function
     * @return void
     */
    public function index()
    {
        //$this->layout = '';
        //$this->loadModel('Customer');
        $this->CustomerNotes->recursive = -1;
        $conditions = array();
        $notes_data = array();
        $page = 1;

        if(isset($this->request->params['named']['keyword'])) {
            $keyword = $this->request->params['named']['keyword'];
        }
        if(isset($this->request->params['named']['page'])) {
            $page = $this->request->params['named']['page'];
        }
        
        if ($this->request->is('post') || !empty($keyword)) {
            if(isset($this->request->data['CustomerNotes']['keyword'])) {
                $keyword = addslashes(trim($this->request->data['CustomerNotes']['keyword']));
            }
            $cond = array();
            
            if(is_numeric($keyword)) {
            	$cond['SalesEntry.client_no LIKE'] = $keyword;
            } else {
            	$cond['Customer.name LIKE'] = '%' . $keyword . '%';
            }
            $conditions['OR'] = $cond;
            $this->request->params['named']['keyword'] = $keyword;
    
            $this->Paginator->settings = array(
                'recursive' => 0,
                'limit' => 30,
                'page' => $page,
                'conditions' => $conditions,
                'order' => array(
                    'SalesEntry.client_no' => 'ASC'
                )
            );
            $customer_data = $this->Paginator->paginate('SalesEntry');
            foreach($customer_data as $data) {
                $notes_data[] = $this->set_payment_detail($data);
            }
        }
        $this->set('notes', $notes_data);
    }


    /**
     * add method
     *
     * @return void
     */
    public function add()
    {
        if ($this->request->is('post')) {
            $this->CustomerNotes->create();
            if ($this->CustomerNotes->save($this->request->data)) {
                $this->Session->setFlash('The customer note has been saved.', 'admin_msg_good');
                return $this->redirect(array('action' => 'index'));
            } else {
                $this->Session->setFlash('The customer note could not be saved. Please, try again.', 'admin_msg_bad');
            }
        }
        $customers = $this->CustomerNotes->Customer->find('all');
        $users = $this->CustomerNotes->User->find('list');
        //pr($customers);exit;
        $this->set('customers', $customers);
        $this->set(compact('users'));
    }

    /**
     * edit method
     *
     * @throws NotFoundException
     * @param string $id
     * @return void
     */
    public function edit($id = null)
    {
        if (!$this->CustomerNotes->exists($id)) {
            throw new NotFoundException(__('Invalid customer note'));
        }
        if ($this->request->is(array('post', 'put'))) {
            if ($this->CustomerNotes->save($this->request->data)) {
                $this->Session->setFlash(__('The customer note has been saved.'));
                return $this->redirect(array('action' => 'index'));
            } else {
                $this->Session->setFlash(__('The customer note could not be saved. Please, try again.'));
            }
        } else {
            $options = array('conditions' => array('CustomerNotes.' . $this->CustomerNotes->primaryKey => $id));
            $this->request->data = $this->CustomerNotes->find('first', $options);
        }
        $customers = $this->CustomerNotes->Customer->find('list');
        $users = $this->CustomerNotes->User->find('list');
        $this->set(compact('customers', 'users'));
    }

    /**
     * delete method
     *
     * @throws NotFoundException
     * @param string $id
     * @return void
     */
    public function delete($id = null)
    {
        $this->CustomerNotes->id = $id;
        if (!$this->CustomerNotes->exists()) {
            throw new NotFoundException(__('Invalid customer note'));
        }
        $this->request->allowMethod('post', 'delete');
        if ($this->CustomerNotes->delete()) {
            $this->Session->setFlash(__('The customer note has been deleted.'));
        } else {
            $this->Session->setFlash(__('The customer note could not be deleted. Please, try again.'));
        }
        return $this->redirect(array('action' => 'index'));
    }

    function customer_detail($cus_id = '')
    {
        $this->loadModel('SalesEntry');

        $result = $this->SalesEntry->findAllByCusId($cus_id);
        $client_no = $result[0]['SalesEntry']['client_no'];
        $this->set('cus', $result[0]['Customer']);
        $this->set('sales', $this->set_payment_detail($result[0]));

        $products = array();
        foreach($result as $data) {
            if(!empty($data['Product'])) {
               $products[$data['SalesEntry']['client_no']] = '['.$data['SalesEntry']['client_no'].'] '.$data['Product']['name'] .' ('.$data['Product']['color'].')';
            }
        }
        $this->set('products', $products);

        $this->loadModel('CustomerNotes');
        $customer_notes = $this->CustomerNotes->find('all', array('conditions' => array('CustomerNotes.client_no' => $client_no), 'order' => array('CustomerNotes.created' => 'ASC')));
        //pr($customer_notes);
        $this->set('notes', $customer_notes);

        $this->loadModel('InstallmentDetail');
        $this->InstallmentDetail->bindModel(array('hasMany' => array('SalesEntry' => array('foreignKey' => 'client_no'))), false);
        $installment_detail = $this->InstallmentDetail->find('all', array('conditions' => array('InstallmentDetail.sales_code' => $client_no), 'order' => array('InstallmentDetail.date' => 'ASC')));
        $this->set('installment_detail', $installment_detail);


        
        $l_note = $this->CustomerNotes->find('first', array(
            'conditions' => array('CustomerNotes.user_id' => $this->Session->read('userData.id'), 'CustomerNotes.notes NOT LIKE' => '%<strong>%'),
            'recursive' => 0,
            'fields' => array('id'),
            'order' => array('CustomerNotes.created' => 'DESC')
            )
        );
        
        if(!empty($l_note)) {
            $this->set('last_note', $l_note['CustomerNotes']['id']);
        } else {
            $this->set('last_note', false);
        }
    }

    function add_customer_notes()
    {
        $this->layout = 'ajax';
        $this->render = false;
        if($this->request->is('ajax')) {
            $this->loadModel('CustomerNotes');
            $this->request->data['CustomerNotes']['user_id'] = $this->Session->read('userData.id');
            $this->request->data['CustomerNotes']['created'] = date('Y-m-d H:i:s');
            $this->CustomerNotes->save($this->request->data);
            echo true;
        }
        die;
    }

    function edit_customer_note() {
        $this->layout = 'ajax';
        $this->render = false;
        if($this->request->is('ajax')) {
            $this->loadModel('CustomerNotes');
            $this->CustomerNotes->id = $this->request->data['note_no'];
            $this->CustomerNotes->save($this->request->data);
            echo 'Note has been saved.';
        }
        die;
    }

    function other_sales_detail()
    {
        $this->render = false;
        $this->layout = 'ajax';
        if($this->request->is('ajax')) {
            $client_no = $this->request->data('client_no');
            $this->loadModel('SalesEntry');

            $result = $this->SalesEntry->findByClientNo($client_no);
            $this->set('sales', $this->set_payment_detail($result));

            $this->loadModel('CustomerNotes');
            $customer_notes = $this->CustomerNotes->find('all', array('conditions' => array('CustomerNotes.client_no' => $client_no), 'order' => array('CustomerNotes.created' => 'ASC')));
            $this->set('notes', $customer_notes);

            $this->loadModel('InstallmentDetail');
            $this->InstallmentDetail->bindModel(array('hasMany' => array('SalesEntry' => array('foreignKey' => 'client_no'))), false);
            $installment_detail = $this->InstallmentDetail->find('all', array('conditions' => array('InstallmentDetail.sales_code' => $client_no), 'order' => array('InstallmentDetail.date' => 'ASC')));
            $this->set('installment_detail', $installment_detail);

            $l_note = $this->CustomerNotes->find('first', array(
                'conditions' => array('CustomerNotes.user_id' => $this->Session->read('userData.id'), 'CustomerNotes.notes NOT LIKE' => '%<strong>%'),
                'recursive' => 0,
                'fields' => array('id'),
                'order' => array('CustomerNotes.created' => 'DESC')
                )
            );
            if(!empty($l_note)) {
                $this->set('last_note', $l_note['CustomerNotes']['id']);
            } else {
                $this->set('last_note', false);
            }
            $this->render('/Elements/product_detail');
        }
    }

    function set_payment_detail($data) {
        $ptd = $data['SalesEntry']['payment_detail'];

        $ptd_check = @unserialize($ptd); 
        
        if($ptd === 'b:0;' || $ptd_check !== false) {
            $ptd = unserialize($ptd);
            if(array_key_exists('cd', $ptd)) {
                $ac_no = $ptd['ac'];
                $cd = unserialize($ptd['cd']);
            } else {
                $ac_no = '';
                $cd = $ptd;
            }
        } else {
            $ac_no = $ptd;
            $cd = array('cd_no' => '', 'cd_month' => '', 'cd_year' => '', 'cvv' => '');
        }

        $pd_str = '<strong>A/C No.: </strong>'.$ac_no."\n";
        $pd_str .= '<strong>CC/DC No.: </strong>'.$cd['cd_no']."\n";
        $pd_str .= '<strong>Month: </strong>'.$cd['cd_month'];
        $pd_str .= '&nbsp;&nbsp;<strong>Year: </strong>'.$cd['cd_year'];
        $pd_str .= '&nbsp;&nbsp;<strong>CVV: </strong>'.$cd['cvv'];

        $data['SalesEntry']['payment_detail'] = $pd_str;
        return $data;
    }

    function download_file($type, $name) {

        $file = $this->Contract->file($name, $type);

        $this->viewClass = 'Media';
        $params = array(
            'id' => $file->name() . '.' . $file->ext(),
            'name' => $file->name(),
            'download' => true,
            'extension' => $file->ext(),
            'path' => $file->folder()->pwd() . DS,   // don't forget terminal 'DS'
            'cache' => false,
        );

        $this->set($params);
    }
}
