<?php

App::uses('AppController', 'Controller');

/**
 * Customers Controller
 *
 * @property Customer $Customer
 * @property PaginatorComponent $Paginator
 * @property SessionComponent $Session
 */
class CustomersController extends AppController
{
    public $c_status = array(
        0 => 'CANCELLED',
        1 => 'ACTIVE'
    );

    public $uses = array('Customer', 'SalesEntry');
    public $components = array('Acl');


    /**
     * Layout
     *
     * @var array
     */
    public $layout = 'admin_home';

    public function beforeFilter()
    {
        parent::beforeFilter();
        $this->Auth->allow('customerStatus');
    }


    /**
     * index method
     *
     * @return void
     */
    public function index()
    {
        $conditions = array();
        $customers = array();
        $page = 1;
        if(isset($this->request->params['named']['keyword'])) {
            $keyword = $this->request->params['named']['keyword'];
        }
        if(isset($this->request->params['named']['page'])) {
            $page = $this->request->params['named']['page'];
        }

        if ($this->request->is('post') || !empty($keyword)) {
            if(isset($this->request->data['Customers']['keyword'])) {
                $keyword = addslashes(trim($this->request->data['Customers']['keyword']));
            } else {
                $this->request->data['Customers']['keyword'] = $keyword;
            }

            $cond = array();
            if(is_numeric($keyword)) {
            	$cond['SalesEntry.client_no LIKE'] = $keyword;
            } else {
            	$cond['Customer.name LIKE'] = '%' . $keyword . '%';
            }

            $conditions['OR'] = $cond;
            $this->request->params['named']['keyword'] = $keyword;

            $this->Paginator->settings = array(
                'recursive' => 0,
                'limit' => 30,
                'page' => $page,
                'conditions' => $conditions,
                'order' => array(
                    'SalesEntry.client_no' => 'ASC'
                )
            );
            
            $customers = $this->Paginator->paginate('Customer');
        }
        $this->set('customers', $customers);
    }

    /**
     * view method
     *
     * @throws NotFoundException
     * @param string $id
     * @return void
     */
    public function view($id = null)
    {
        if (!$this->Customer->exists($id)) {
            throw new NotFoundException(__('Invalid customer'));
        }
        $options = array('conditions' => array('Customer.' . $this->Customer->primaryKey => $id));
        $this->set('customer', $this->Customer->find('first', $options));
    }

    /**
     * add method
     *
     * @return void
     */
    public function add()
    {
        if ($this->request->is('post')) {
            $date_time = date('Y-m-d H:i:s');
            $this->request->data['Customer']['created'] = $date_time;
            $this->request->data['Customer']['modified'] = $date_time;
            if($this->Customer->save($this->request->data)) {
                $this->Session->setFlash('The customer has been saved.', 'admin_msg_good');
                return $this->redirect(array('action' => 'index'));
            } else {
                $this->Session->setFlash(__('The customer could not be saved. Please, try again.'));
            }
        }
    }

    /**
     * edit method
     *
     * @throws NotFoundException
     * @param string $id
     * @return void
     */
    public function edit($id = null)
    {
        $data = $this->Customer->read(null, $id);
        $c_status = $data['Customer']['status'];
        if($this->request->is(array('post', 'put'))) {
            $c_status = $this->request->data['Customer']['c_status'];
            $c_status = ($c_status == 0) ? 1 : 0;
            $this->request->data['Customer']['status'] = $c_status;
            $this->request->data['Customer']['modified'] = date('Y-m-d H:i:s');
            $this->Customer->id = $id;

            if($this->Customer->save($this->request->data)) {
                if($this->request->data['Customer']['cancellation_note'] != '') {
                    $this->save_note($id, $this->request->data['Customer']['cancellation_note'], $c_status);
                }
                $this->Session->setFlash('Customer saved Sucessfully', 'admin_msg_good');
                return $this->redirect(array('action' => 'index'));
            } else {
                $this->Session->setFlash('The Customer could not be saved. Please, try again.', 'admin_msg_bad');
            }
        }

        $data['Customer']['c_status'] = ($c_status == 0) ? 1 : 0;

        if(!$this->request->data) {
            $this->data = $data;
        }
    }

    function save_note($cus, $note, $status) {
        $this->loadModel('CustomerNotes');
        $this->loadModel('SalesEntryAltered');

        $sales = $this->SalesEntry->find('all', array('fields' => array('id', 'client_no'), 'conditions' => array('SalesEntry.cus_id' => $cus)));;

        foreach($sales as $sale) {
            $cancel_notes[] = array(
                'user_id'   => $this->Session->read('userData.id'),
                'client_no' => $sale['SalesEntry']['client_no'],
                'notes'     => $note,
                'created'   => date('Y-m-d H:i:s')
            );

            if($status == 1) {
                $sea_client = $this->SalesEntryAltered->hasAny(array('SalesEntryAltered.client_no' => $sale['SalesEntry']['client_no']));
                if($sea_client) {
                    $s_status = 2;
                } else {
                    $s_status = 1;
                }
            }  else {
                $s_status = 0;
            }                          
            $sales_status[] = array(
                'id'        => $sale['SalesEntry']['id'],
                'status'    => $s_status
            );
        }
        $this->CustomerNotes->saveMany($cancel_notes);
        $this->SalesEntry->saveMany($sales_status);
    }

    /**
     * delete method
     *
     * @throws NotFoundException
     * @param string $id
     * @return void
     */
    public function delete()
    {
        if (!empty($_POST)) {
            foreach ($_POST['delete_all'] as $key => $val) {
                $this->Customer->delete($val);
            }
            $this->Session->setFlash('Customer Deleted Sucessfully', 'admin_msg_good');
            return $this->redirect(array('action' => 'index'));
        }
    }

    public function customerStatus() {
        $this->autoRender = FALSE;
        if($this->request->is('ajax')) {
            switch($_GET['status']) {
                case 1:
                    $this->Customer->updateAll(array('Customer.status' => 0), array('Customer.id' => $_GET['id']));
                    break;
                case 0:
                    $this->Customer->updateAll(array('Customer.status' => 1), array('Customer.id' => $_GET['id']));
                    break;
            }
        }
    }

    function import_csv() {
        if ($this->request->is('post')) {
            $file_name = $this->request->data['Customer']['file']['name'];
            $filename = $this->request->data['Customer']['file']['tmp_name'];
            $tempFile = new File($file_name);
            $ext = $tempFile->ext();
            $ext = strtolower($ext);
            $types = array('csv');
            $val = in_array($ext, $types, true);
            if ($val) {
                // open the file
                $handle = fopen($filename, 'r');
                $this->loadModel('InstallmentDetail');
                $this->loadModel('SalesEntry');
                App::uses('CakeTime', 'Utility');
                $data_arr = array();
                $counter = 0;
                while($row = fgetcsv($handle, 0, "\n")) {
                    $row = explode(',', $row[0]);
                    if(!in_array($row[0], array('', 'date', 'Date'))) {
                        $this->InstallmentDetail->create();
                        $data_arr['InstallmentDetail']['amount'] = trim($row[1]);
                        $data_arr['InstallmentDetail']['payee'] = addslashes(trim($row[2]));
                        $data_arr['InstallmentDetail']['particulars'] = addslashes(trim($row[3]));
                        $data_arr['InstallmentDetail']['sales_code'] = trim($row[4]);
                        $data_arr['InstallmentDetail']['reference'] = addslashes(trim($row[5]));
                        $data_arr['InstallmentDetail']['payment_mode'] = addslashes(trim($row[6]));
                        /*$installment_date = CakeTime::format(trim($row[0]), '%Y-%m-%d', 0, new DateTimeZone('Pacific/Auckland'));
                        $data_arr['InstallmentDetail']['date'] = $installment_date;
                        $installment_date = DateTime::createFromFormat('j-m-y', $row[0], new DateTimeZone('Pacific/Auckland'));
                        $data_arr['InstallmentDetail']['date'] = $installment_date->format('Y-m-d');*/
                        $data_arr['InstallmentDetail']['date'] = trim($row[0]);
                        $data_arr['InstallmentDetail']['has_client'] = 0;
                        if(!empty($row[4]) && $this->SalesEntry->hasAny(array('SalesEntry.client_no' => trim($row[4])))) {                   
                            $data_arr['InstallmentDetail']['has_client'] = 1;
                        }
                        $data_arr['InstallmentDetail']['created'] = date('Y-m-d');
                        $this->InstallmentDetail->save($data_arr);
                        $counter++;
                    }
                }
                $this->Session->setFlash($counter.' records imported from your CSV.', 'admin_msg_good');
                $this->render('/Customers/import_csv');
            } else {
                $this->Session->setFlash('Please select csv file only.', 'admin_msg_bad');
                $this->render('/Customers/import_csv');
            }
            //  die;
        }
    }

}