<?php

App::uses('AppController', 'Controller');

/**
 * Products Controller
 *
 * @property Product $Product
 * @property PaginatorComponent $Paginator
 * @property SessionComponent $Session
 */
class ProductsController extends AppController {

    /**
     * Layout
     *
     * @var array
     */
    public $layout = 'admin_home';
    public $components = array('Acl');
    
    public function beforeFilter() {
        parent::beforeFilter();
        $this->Auth->allow('productStatus');
    }
    
    
    /**
     * index method
     *
     * @return void
     */
    public function index() {      

        $this->Paginator->settings = array(
            'recursive' => 0,
            'limit' => 30,
            'order' => array(
                'Product.name' => 'ASC'
            )
        );
        
        $products = $this->Paginator->paginate('Product');
        $this->set('products', $products);
    }

    /**
     * view method
     *
     * @throws NotFoundException
     * @param string $id
     * @return void
     */
    public function view($id = null) {
        if (!$this->Product->exists($id)) {
            throw new NotFoundException(__('Invalid product'));
        }
        $options = array('conditions' => array('Product.' . $this->Product->primaryKey => $id));
        $this->set('product', $this->Product->find('first', $options));
    }

    /**
     * add method
     *
     * @return void
     */
    public function add() {
        if ($this->request->is('post')) {
            $currentDate = date('Y-m-d H:i:s');
            $this->request->data['Product']['created'] = $currentDate;
            $this->request->data['Product']['modified'] = $currentDate;
            $this->Product->create();
            if ($this->Product->save($this->request->data)) {
                $this->Session->setFlash('The product has been saved.', 'admin_msg_good');
                return $this->redirect(array('action' => 'index'));
            } else {
                $this->Session->setFlash(__('The product could not be saved. Please, try again.'));
            }
        }
        $categories = $this->Product->Category->find('list');
        $this->set(compact('categories'));
    }

    /**
     * edit method
     *
     * @throws NotFoundException
     * @param string $id
     * @return void
     */
    public function edit($id = null) {
        $data = $this->Product->read(null, $id);
        
        if ($this->request->is(array('post', 'put'))) {
            $currentDate = date('Y-m-d H:i:s');
            $this->request->data['Product']['modified'] = $currentDate;
            $this->Product->id = $id;
            if ($this->Product->save($this->request->data)) {
                $this->Session->setFlash('Group saved Sucessfully', 'admin_msg_good');
                return $this->redirect(array('action' => 'index'));
            } else {
                $this->Session->setFlash(__('The group could not be saved. Please, try again.','admin_msg_bad'));
            }
        } 
        
        if (!$this->request->data) {
            $this->data = $data;
        }
        
        $categories = $this->Product->Category->find('list');
        $this->set(compact('categories'));
    }

    /**
     * delete method
     *
     * @throws NotFoundException
     * @param string $id
     * @return void
     */
   public function delete($id = null) {
        if (!empty($_POST)) {
            foreach ($_POST['delete_all'] as $key => $val) {
                $this->Product->delete($val);
            }
            $this->Session->setFlash('Group Deleted Sucessfully', 'admin_msg_good');
            return $this->redirect(array('action' => 'index'));
        }
    }
    
    public function productStatus(){
        $this->autoRender = FALSE;
        if($this->request->is('ajax')) {
            switch ($_GET['status']) {
                case 1:
                    $this->Product->updateAll(array('Product.status' => 0), array('Product.id' => $_GET['id']));
                    break;
                case 0:
                    $this->Product->updateAll(array('Product.status' => 1), array('Product.id' => $_GET['id']));
                    break;
            }
        }
    }

}
