<?php
App::uses('AppController', 'Controller');

class UseraccessController extends AppController {
    
	public $layout = 'admin_home';
	public $components = array('Acl');

    public function beforeFilter() {
        parent::beforeFilter();
        $this->Auth->allow('no_access');
    }

    public function index() {
    }

    public function groups() {

      $this->loadModel('Group');
      $this->Group->recursive = 0;
      $ua_groups = $this->Group->find('all', array('fields' => array('id', 'role')));
      $this->set(compact('ua_groups'));     
      
      $this->set('permissions', $this->get_permissions($ua_groups, $this->Group));
    }

    public function user($id = null) {

      $this->loadModel('User');     
      $this->User->recursive = 0;       

      if(empty($id)) {
        $ua_users = $this->User->find('all', array('fields' => array('id', 'name', 'Group.role')));
        $this->set(compact('ua_users'));
      } else {
        $ua_user = $this->User->find('all', array('conditions' => array('User.id' => $id), 'fields' => array('id', 'name', 'Group.role')));     
        $this->set(compact('ua_user'));
        $this->set('permissions', $this->get_permissions($ua_user, $this->User));
      }
    }

    public function get_permissions($aros, &$obj) {      
      $p = array();
      $aco =& $this->Acl->Aco;

      $aco->recursive = 0;
      $controllers = $aco->find('all', array('conditions' => array('parent_id' => 1)));

      foreach($controllers as $k => $a) {
        $methods = $aco->find('all', array('conditions' => array('parent_id' => $a['Aco']['id'])));
        $ms = array();
        foreach($methods as $m) {
          $ms[] = $m['Aco']['alias'];
        }
        $controllers[$a['Aco']['alias']] = $ms;
        unset($controllers[$k]);
      }

      foreach($controllers as $c => $methods) {
        foreach($aros as $a) {
          $obj->id = $a[$obj->name]['id'];

          foreach($methods as $m) {
            if($obj->name == 'User') {
              $p[$c][$m] = $this->Acl->check($obj, 'controllers/'.$c.'/'.$m);
            } elseif($obj->name == 'Group')
              $p[$c][$a['Group']['role']][$m] = $this->Acl->check($obj, 'controllers/'.$c.'/'.$m);
          }          
        }        
      }

      return $p;
    }

    public function change_permission() {
        $this->render = false;
        $this->layout = 'ajax';

        if($this->request->is('ajax')) {
          $this->loadModel('User');

          $change = $this->request->data('change');
          $model = $this->request->data('model');
          $aco = 'controllers/'.$this->request->data('path');

          if($model == 'user') {
            $aro =& $this->User;
          } elseif($model == 'group') {
            $aro =& $this->User->Group;
          }
          $aro->id = $this->request->data('number');

          if($change == 'allow') {
            $is_changed = $this->Acl->allow($aro, $aco);
          } elseif($change == 'deny') {
            $is_changed = $this->Acl->deny($aro, $aco);
          }
          //echo json_encode(array('model' => $model, 'change' => $change, 'no' => $aro->id, 'path' => $aco));
          echo (empty($is_changed)) ? false : true;
        }
        exit;
    }

    public function no_access() {
   	
    }
}
