<?php
App::uses('AppModel', 'Model');
/**
 * CustomerNotes Model
 *
 * @property Customer $Customer
 * @property User $User
 */
class CustomerNotes extends AppModel {


	//The Associations below have been created with all possible keys, those that are not needed can be removed

/**
 * belongsTo associations
 *
 * @var array
 */   public $name = 'CustomerNotes';
    public $useTable = 'customer_notes';

	public $belongsTo = array(		
		'User' => array(
			'className'		=> 'User',
			'foreignKey'	=> false,
			'conditions' 	=> array('User.id = CustomerNotes.user_id'),
			'fields'		=> array('id', 'name')
		),
		'SalesEntry' => array(
			'className' 	=> 'SalesEntry',
			'foreignKey' 	=> false,
			'conditions' 	=> array('SalesEntry.client_no = CustomerNotes.client_no')
		),
		'Customer' => array(
			'className' 	=> 'Customer',
			'foreignKey' 	=> false,
			'conditions' 	=> array('Customer.id = SalesEntry.cus_id'),
		)
	);
}
?>