<?php
class SalesEntry extends AppModel {
    public $name = 'SalesEntry';
    public $useTable = 'sales_entry';
    
    public $belongsTo = array(
        'User'=>array(
            'className'     => 'User',
			'foreignKey'     => 'user_id'
        ),
        'TL'=>array(
            'className'     => 'User',
            'foreignKey'    => 'tl_id'
        ),
        'Product'=>array(
            'className'     => 'Product',
			'foreignKey'    => 'product_id'
        )

    );
    public $hasOne = array(      
        'Customer' => array(
            'className'     => 'Customer',
            'foreignKey'    => false,
            'conditions'    => array('SalesEntry.cus_id = Customer.id')
        )
    );
} 
?>