<script>
    function check_search() {
        var name_code_val = $("#search_code").val();
        // var status=$("#sts").val();
        if (name_code_val == "") {
            alert("Please enter your search criteria to perform search.");
            return false;
        }
    }
</script>
<div class="row-fluid">
    <div class="span12">
        <!-- BEGIN PAGE TITLE & BREADCRUMB-->
        <h3 class="page-title">
            <h3><?php echo __('Customer Details</h3>'); ?>
        </h3>

    </div>
</div>

<div class="widget green">
    <div class="widget-title">
        <h4><i class="icon-reorder"></i>Notes</h4>
    </div>

    <div class="widget-body big_search">
        <?php echo $this->Form->create('CustomerNotes', array('url' => array('controller' => 'CustomerNotes', 'action' => 'index'))); ?>
        <?php echo $this->Form->input('keyword', array('placeholder' => 'client_no / customer_name / mobile / dob', 'type' => 'text', 'id' => 'search_code', 'label' => false, "div" => false, 'required' => false, 'class' => 'search_required', 'maxlength' => 200)); ?>
        <?php echo $this->Form->submit('Search', array("div" => false, 'onclick' => 'return check_search();')); ?>
        <button><a href="">Reset</a></button>
        <?php echo $this->Form->end();

            if (!empty($notes)) {
                ?>
                <table class="table table-striped table-bordered">
                    <thead>
                    <tr>
                        <th>Client No</th>
                        <th>Customer Name</th>
                        <th>Birth Date</th>
                        <th>Landline</th>
                        <th>Mobile</th>
                        <th>Suburb</th>
                        <th>City</th>
                        <th>Bank Detail</th>
                    </tr>
                    </thead>
                    <tbody>
                        <?php $i = 0; foreach ($notes as $note):
                            $dob = $note['Customer']['dob'];
                            if($dob != '0000-00-00') {
                                $dob = new DateTime($dob);
                                $dob = $dob->format('d-m-Y');
                            } else {
                                $dob = '';
                            }
                            $bd = (!empty($note['SalesEntry'])) ? $note['SalesEntry']['payment_detail'] : '';
                        ?>

                    <tr class="odd gradeX">
                        <td><?php 
                        if($this->acl->check($user, 'controllers/'.strtolower($con).'/customer_detail')) :
                            echo $this->Html->link($note['SalesEntry']['client_no'], array('controller' => 'CustomerNotes', 'action' => 'customer_detail', $note['Customer']['id']), array('title' => 'Customer Detail', 'escape' => false));
                        else :
                            echo $note['SalesEntry']['client_no'];
                        endif;
                        ?></td>
                        <td><?php echo ucfirst($note['Customer']['name']); ?></td>
                        <td><?php echo $dob; ?></td>
                        <td><?php echo $note['Customer']['phone'] ?></td>
                        <td><?php echo $note['Customer']['mobile'] ?></td>
                        <td><?php echo $note['Customer']['suburb'] ?></td>
                        <td><?php echo $note['Customer']['city'] ?></td>
                        <td><?php echo nl2br($bd); ?></td>
                    </tr>
                        <?php $i++; endforeach; ?>
                    </tbody>
                </table>
                <div class="row-fluid" style="margin-top:20px;">
                    <div class="span6 offset6">
                        <div class="dataTables_paginate paging_bootstrap pagination">
                            <ul>                            
                            <?php
                                echo $this->Paginator->numbers(array(
                                    'modulus'       => 4,
                                    'first'         => '< First',
                                    'last'          => 'Last >',
                                    'before'        => '',
                                    'after'         => '',
                                    'separator'     => '',
                                    'tag'           => 'li',
                                    'currentClass' => 'active',
                                    'currentTag'    => 'a'
                                  )
                                );
                            ?>
                            </ul>
                        </div>
                    </div>
                </div>
                <?php } ?>
    </div>
</div>