<div class="widget green clearfix">
    <div class="widget-title">
        <h4><i class="icon-reorder"></i>Account Detail</h4>
    </div> 
    <div class="span6">
        <table class="table table-striped table-bordered">
            <tr class="odd gradeX">
                <th>Product Name:</th>
                <td><?php echo ucwords($sales['Product']['name']); ?></td>
            </tr>
            <tr>
                <th>Size:</th>
                <td><?php echo $sales['Product']['size']; ?></td>
            </tr>
            <tr class="odd gradeX">
                <th>Color:</th>
                <td><?php echo $sales['Product']['color']; ?></td>
            </tr>
            <tr>
                <th>Promo 1:</th>
                <td><?php echo ($sales['SalesEntry']['promo_1'] != '') ? $sales['SalesEntry']['promo_1'] : 'N/A'; ?></td>
            </tr>
            <tr class="odd gradeX">
                <th>Promo 2:</th>
                <td><?php echo ($sales['SalesEntry']['promo_2'] != '') ? $sales['SalesEntry']['promo_2'] : 'N/A'; ?></td>
            </tr>
            <tr>
                <th>Promo 3:</th>
                <td><?php echo ($sales['SalesEntry']['promo_3'] != '') ? nl2br($sales['SalesEntry']['promo_3']) : 'N/A'; ?></td>
            </tr>
            <tr class="odd gradeX">
                <th>Product Delivery Status:</th>
                <td><?php echo ($sales['SalesEntry']['delivery_status']) ? 'DELIVERED' : 'NOT DELIVERED'; ?></td>
            </tr>
            <tr>
                <th>Tracking No.:</th>
                <td><?php echo $sales['SalesEntry']['tracking_no']; ?></td>
            </tr>
            <tr class="odd gradeX">
                <th>Plan ID:</th>
                <td><?php echo $sales['SalesEntry']['plan_id']; ?></td>
            </tr>
        </table>
    </div>
    <?php
        echo '<span id="tmp_client">'.$sales['SalesEntry']['client_no'].'</span>';
        echo '<span id="tmp_status">'.$sales['SalesEntry']['status'].'</span>';
        $ins_no = 0;
        $total_ins_amt = 0;
        $total_ins_amt += $sales['SalesEntry']['initial_payment'];
        $mops = array();
        $install_tbl = '';
        foreach($installment_detail as $key => $value) {
            $id = $value['InstallmentDetail'];
            if(!isset($mops[$id['payment_mode']]['amount'])) { $mops[$id['payment_mode']]['amount'] = 0; }
            if(!isset($mops[$id['payment_mode']]['installment'])) { $mops[$id['payment_mode']]['installment'] = 0; }
            $mops[$id['payment_mode']]['amount'] += $id['amount']; 
            $mops[$id['payment_mode']]['installment']++;
            $total_ins_amt += $id['amount'];
            $date = new DateTime($id['date']);
            $install_tbl .= '<tr><td>'.++$ins_no.'</td>';
            $install_tbl .= '<td>'.$date->format('d M Y').'</td>';
            $install_tbl .= '<td>'.$id['particulars'].'</td>';
            $install_tbl .= '<td>'.$id['reference'].'</td>';
            $install_tbl .= '<td>'.$id['payment_mode'].'</td>';
            $install_tbl .= '<td>'.$id['amount'].'</td></tr>';
        }
        foreach($mops as $mop => $detail) {                            
        $install_tbl .= '<tr><td colspan="2" style="text-align:right;"><strong><em>Total '.$mop.' Installments:</em></strong></td><td><strong>'.$detail['installment'].'</strong></td>';
        $install_tbl .= '<td colspan="2" style="text-align:right;"><strong><em>Total '.$mop.':</em></strong></td><td><strong>'.$detail['amount'].'</strong></td></tr>';
        }
        $install_tbl .= '<tr><td colspan="5" style="text-align:right;"><strong><em>Initial Payment:</em></strong></td>';
        $install_tbl .= '<td><strong>'.$sales['SalesEntry']['initial_payment'].'</strong></td></tr>';
        $install_tbl .= '<tr><td colspan="2" style="text-align:right;"><strong><em>Total Installments:</em></strong></td>';
        $install_tbl .= '<td><strong>'.$ins_no.'</strong></td>';
        $install_tbl .= '<td colspan="2" style="text-align:right;"><strong><em>Total Amount:</em></strong></td>';
        $install_tbl .= '<td><strong>'.$total_ins_amt.'</strong></td></tr>';

    ?>
    <div class="span6" style="margin-left:0;">
        <table class="table table-striped table-bordered">
            <tr class="odd gradeX">
                <th>Total Price:</th>
                <td><?php echo $sales['Product']['price']; ?></td>
            </tr>
            <tr>
                <th>Setup / Other Fees:</th>
                <td><?php echo $sales['SalesEntry']['setup_other_fees']; ?></td>
            </tr>
            <tr class="odd gradeX">
                <th>Amount Per Payment:</th>
                <td><?php echo $sales['SalesEntry']['amount_per_payment']; ?></td>
            </tr>
            <tr>
                <th>Total Remaining:</th>
                <td><?php echo ($sales['SalesEntry']['total_payment'] - $total_ins_amt); ?></td>
            </tr>
            <tr class="odd gradeX">
                <th>Bank Detail:</th>
                <td><?php echo nl2br($sales['SalesEntry']['payment_detail']); ?></td>
            </tr>
            <tr class="odd gradeX">
                <th>Payment Start Date:</th>
                <?php
                    $psd = $sales['SalesEntry']['payment_start_date'];
                    if($psd != '0000-00-00') {
                        $psd = new DateTime($psd);
                        $psd = $psd->format('d-m-Y');
                    } else {
                        $psd = '';
                    }
                ?>
                <td><?php echo $psd; ?></td>
            </tr>
            <tr>
                <th>Delivery date:</th>
                <?php
                    $pdd = $sales['SalesEntry']['product_delivery_date'];
                    if($pdd != '0000-00-00') {
                        $pdd = new DateTime($pdd);
                        $pdd = $pdd->format('d-m-Y');
                    } else {
                        $pdd = '';
                    }
                ?>
                <td><?php echo $pdd; ?></td>
            </tr>
            <tr class="odd gradeX">
                <th>Invoice Generated:</th>
                <td><?php echo ($sales['SalesEntry']['invoice_generated']) ? 'YES' : 'NO'; ?></td>
            </tr>
        </table>
    </div>
    <div class="span12" style="margin-left:0 !important;">
        <table class="table table-striped table-bordered">
            <tr>
                <td><strong>Comments:</strong></td>
                <td colspan="5"><?php echo $sales['SalesEntry']['comments']; ?></td>
            </tr>
            <tr>
                <td><strong>Contract:</strong></td>
                <td>
                <?php
                    if(!empty($sales['SalesEntry']['contract'])) {

                        $contracts_html = '<table class="table table-bordered table-striped" style="width:auto">';
                        $contracts = explode(',', $sales['SalesEntry']['contract']);
                        
                        foreach($contracts as $i => $contract) {
                    
                            $contracts_html .= '<tr>';
                            $contracts_html .= sprintf('<th>%d</th>', ++$i);
                            $contracts_html .= "<td>{$this->Html->link('Download ' . $contract, array('action' => 'download_file', 'contract', $contract), array('class' => 'frm_lnk', 'escape' => false))}</td>";
                            $contracts_html .= '</tr>';
                        }

                        $contracts_html .= '</table>';

                        echo $contracts_html;
                    
                    } else {
                        echo '<em>No Contract</em>';
                    }
                ?>
                </td>
            </tr>
            <tr>
                <td><strong>Recordings:</strong></td>
                <td>
                <?php
                    if(!empty($sales['SalesEntry']['recordings'])) {

                        $recordings_html = '<table class="table table-bordered table-striped" style="width:auto">';
                        $recordings = explode(',', $sales['SalesEntry']['recordings']);
                        
                        foreach($recordings as $i => $recording) {

                            $player = $this->Html->media([$recording], [
                                'controls' => true,
                                'style' => 'width:400px',
                                'pathPrefix' => 'SalesEntry/play_recording/recordings/',
                                'text' => 'Can\'t play recording in this browser. Please use different browser.',
                            ]);
                    
                            $recordings_html .= '<tr>';
                            $recordings_html .= sprintf('<th>%d</th>', ++$i);
                            $recordings_html .= "<td>{$player}</td>";
                            $recordings_html .= "<td>{$this->Html->link('Download ' . $recording, array('action' => 'download_file', 'recordings', $recording), array('class' => 'frm_lnk', 'escape' => false))}</td>";
                            $recordings_html .= '</tr>';
                        }

                        $recordings_html .= '</table>';

                        echo $recordings_html;
                        
                    } else {
                        echo '<em>No Recordings</em>';
                    }
                ?>
                </td>
            </tr>
        </table>
    </div>
    <div class="span12" style="margin-left:0 !important;">
        <div class="widget green" style="margin:20px auto !important;width: 80%;">
        <div class="widget-title">
            <h4>Installment Detail</h4>
        </div>
            <table class="table table-striped table-bordered" style="margin: 0;">
                <tr>
                    <th>Installment No.</th>
                    <th>Date</th>
                    <th>Perticulars</th>
                    <th>Referance</th>
                    <th>Transaction Type</th>
                    <th>Amount</th>
                </tr>
                <?php echo $install_tbl; ?>
            </table>
        </div>
    </div>
</div>
            <div class="widget green clearfix">
                <div class="widget-title">
                    <h4><i class="icon-reorder"></i>Product Notes</h4>
                </div>
                <div class="widget green" style="margin:20px;">
                <div class="widget-title">
                    <h4>Previous Notes</h4>
                </div>
                <div id="prev_notes" style="padding:20px;overflow-y:scroll;height:200px;">
                <?php if (!empty($notes)) {
                foreach ($notes as $note) { $this_note_id = $note['CustomerNotes']['id'];
                    echo '<div style="margin-bottom:20px;"><p style="margin:0 0 5px;"><em><strong>'. $note['User']['name'] . ':</strong> <u>' . date('d-m-Y h:i:s A', strtotime($note['CustomerNotes']['created'])) . '</u></em>';
                    if($last_note === $this_note_id) { echo '<span style="float:right;cursor:pointer;" class="label label-success" data-note="'.$this_note_id.'">Edit</span>'; }
                    echo '</p><p class="note" style="background-color:#f6f6f6;margin-left:10px;padding:5px;">' . nl2br($note['CustomerNotes']['notes']).'</p></div>';
                }
            }?>
                </div>
                </div>
                <?php
                if($this->acl->check($user, 'controllers/'.strtolower($con).'/add_customer_notes')) :
                echo '<div class="widget green" style="margin:20px;"><div class="widget-title"><h4>Create Note</h4></div>'.$this->Form->input('CustomerNotes.notes', array('type' => 'textarea',
                                                                        'label' => FALSE,
                                                                        'class' => 'span6',
                                                                        'id' => 'customer_notes',
                                                                        'required' => true,
                                                                        'div' => 'controls',
                                                                        'style' => 'margin:10px;width:98%;'
                                                                    ));
                ?>
                    <input id="save_note" type="button" value="Save Note" onclick="return add_notes(this);" style="margin-left:10px" data-action="save" />
                <?php echo '</div>'; endif; ?> 
        </div>