<script>
    function check_search() {
        var name_code_val = $("#search_code").val();
        // var status=$("#sts").val();
        if (name_code_val == "") {
            alert("Please enter your search criteria to perform search.");
            return false;
        }
    }
</script>
<div class="row-fluid">
    <div class="span12">
        <!-- BEGIN PAGE TITLE & BREADCRUMB-->
        <h3 class="page-title">
            <h3><?php echo __('Sales Management'); ?></h3>
        </h3>

    </div>
</div>

<div class="widget green">
    <div class="widget-title">
        <h4><i class="icon-reorder"></i>Sales Entry</h4>
        <span class="tools">
        <?php
            if($this->acl->check($user, 'controllers/'.strtolower($con).'/add')) {
                echo '<a href="'.$this->webroot.'SalesEntry/add">Add</a>';
            }
            $can_edit = $this->acl->check($user, 'controllers/'.strtolower($con).'/edit');
            $can_delete = $this->acl->check($user, 'controllers/'.strtolower($con).'/delete');
            if(!empty($sales) && $can_delete) {
                echo '<a href="javascript:void(0)"  onclick="javascript:submitForm()">Delete</a>';
            }
        ?>
        </span>
    </div>

    <div class="widget-body big_search">
        <?php echo $this->Form->create('SalesEntry', array('url' => array('controller' => 'SalesEntry', 'action' => 'index'))); ?>
        <?php echo $this->Form->input('keyword', array('placeholder' => 'client_no / customer_name / mobile_no / dob', 'type' => 'text', 'id' => 'search_code', 'label' => false, "div" => false, 'required' => false, 'class' => 'search_required', 'maxlength' => 200)); ?>
        <?php echo $this->Form->submit('Search', array("div" => false, 'onclick' => 'return check_search();')); ?>
        <button><a href="">Reset</a></button>
        <?php echo $this->Form->end();

            if (!empty($sales)) {
if($can_delete) :
             ?>
    <form id="frm_delete_all" method="post" action="<?php echo $this->webroot; ?>salesEntry/delete">
<?php endif; ?>
            <table class="table table-striped table-bordered" id="sales_entry_tbl">
                <thead>
                    <tr>
                    <?php if($can_delete) : ?>
                        <th style="width:8px;"><input type="checkbox" class="group-checkable" data-set="#sales_entry_tbl .checkboxes" /></th>
                    <?php endif; ?>
                        <th>Client No.</th>
                        <th>Customer Name</th>
                        <th>Product Name</th>
                        <th>Agent Name</th>
                        <th>TL Name</th>
                        <th>Sales Date</th>
                    </tr>
                </thead>
                <tbody>
                <?php foreach($sales as $sale) :
                    $db_added_date = $sale['SalesEntry']['added_date'];
                    if($db_added_date != '0000-00-00') {
                        $db_added_date = new DateTime($db_added_date);
                        $db_added_date = $db_added_date->format('d-m-Y');
                    } else {
                        $db_added_date = '';
                    }
                ?>

                    <tr class="odd gradeX">
                    <?php if($can_delete) : ?>
                        <td><input type="checkbox" multiple="multiple" class="checkboxes" name="delete_all[]" id="delete_all" value="<?php echo $sale['SalesEntry']['id']; ?>"  /></td>
                    <?php
                        endif;
                        if($can_edit) :
                    ?>
                        <td><?php echo $this->Html->link($sale['SalesEntry']['client_no'],array("action"=>"edit",$sale['SalesEntry']['id'])); ?></td>
                    <?php else : ?>
                        <td><?php echo $sale['SalesEntry']['client_no'] ?></td>
                    <?php endif; ?>
                        <td><?php echo $sale['Customer']['name']; ?></td>
                        <td><?php echo $sale['Product']['name']; ?></td>
                        <td><?php echo $sale['User']['name']; ?></td>
                        <td><?php echo $sale['TL']['name']; ?></td>
                        <td><?php echo $db_added_date; ?></td>
                    </tr>

                <?php endforeach; ?>
                </tbody>
            </table>
            <div class="row-fluid" style="margin-top:20px;">
                <div class="span6 offset6">
                    <div class="dataTables_paginate paging_bootstrap pagination">
                        <ul>                            
                        <?php
                            echo $this->Paginator->numbers(array(
                                'modulus'       => 4,
                                'first'         => '< First',
                                'last'          => 'Last >',
                                'before'        => '',
                                'after'         => '',
                                'separator'     => '',
                                'tag'           => 'li',
                                'currentClass' => 'active',
                                'currentTag'    => 'a'
                              )
                            );
                        ?>
                        </ul>
                    </div>
                </div>
            </div>
        <?php if($can_delete) : ?> </form> <?php endif; ?>
        <?php } ?>
    </div>
</div>

<?php if($can_delete) : ?>
<script>
    function submitForm() {
        var n = $("input:checkbox:checked").length;
        if (n == 0) {
            alert("Please Select at least one record");
            return false;
        } else {
            if (confirm("Are You Sure?") == true) {
                document.getElementById("frm_delete_all").submit();
            }
        }
    }
</script>
<?php endif; ?>