
<div class="row-fluid">
    <div class="span12">
        <!-- BEGIN PAGE TITLE & BREADCRUMB-->
        <h3 class="page-title">
            <h3><?php echo __('Missing Payments'); ?></h3>
        </h3>

    </div>
</div>

<div class="widget green">
    <div class="widget-title">
        <h4><i class="icon-reorder"></i>Missing Payments</h4>
    </div>

    <div class="widget-body big_search">
        <table class="table table-striped table-bordered" id="missing_payments_tbl">
            <thead>
                <tr>
                    <th>Client No.</th>
                    <th>Amount</th>
                    <th>Payee</th>
                    <th>Particulars</th>
                    <th>Reference</th>
                    <th>MOD</th>
                    <th>Date</th>
                    <th>Added Date</th>
                </tr>
            </thead>
            <tbody>
            <?php foreach($mps as $mp) :
                $date = $mp['InstallmentDetail']['date'];
                if($date != '0000-00-00') {
                    $date = new DateTime($date);
                    $date = $date->format('d-m-Y');
                } else {
                    $date = '';
                }
                $added_date = $mp['InstallmentDetail']['created'];
                if($added_date != '0000-00-00') {
                    $added_date = new DateTime($added_date);
                    $added_date = $added_date->format('d-m-Y');
                } else {
                    $added_date = '';
                }
            ?>

                <tr class="odd gradeX">
                    <td><?php echo $this->Form->input('mp.client', array('label' => FALSE, 'class' => 'client', 'div' => FALSE, 'value' => $mp['InstallmentDetail']['sales_code'], 'data-key' => $mp['InstallmentDetail']['id'], 'autocomplete' => 'off', 'readonly' => true, 'title' => 'Click to edit')) ?> <span class="c_save">Save</span> <span class="c_cancel">Cancel</span></td>
                    <td><?php echo $mp['InstallmentDetail']['amount']; ?></td>
                    <td><?php echo $mp['InstallmentDetail']['payee']; ?></td>
                    <td><?php echo $mp['InstallmentDetail']['particulars']; ?></td>
                    <td><?php echo $mp['InstallmentDetail']['reference']; ?></td>
                    <td><?php echo $mp['InstallmentDetail']['payment_mode']; ?></td>
                    <td><?php echo $date; ?></td>
                    <td><?php echo $added_date; ?></td>
                </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
        <div class="row-fluid" style="margin-top:20px;">
            <div class="span6 offset6">
                <div class="dataTables_paginate paging_bootstrap pagination">
                    <ul>                            
                    <?php
                        echo $this->Paginator->numbers(array(
                            'modulus'       => 4,
                            'first'         => '< First',
                            'last'          => 'Last >',
                            'before'        => '',
                            'after'         => '',
                            'separator'     => '',
                            'tag'           => 'li',
                            'currentClass' => 'active',
                            'currentTag'    => 'a'
                          )
                        );
                    ?>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>
<style>
input.client {
    margin: 0;
    width: 60px;
}
span.c_save,
span.c_cancel {
    display: none;
}
span.c_save:hover,
span.c_cancel:hover {
    cursor: pointer;
    text-decoration: underline;
}
</style>
<script type="text/javascript">
$(document).ready(function() {
    var original = '';
    $('input.client').click(function() {
        original = $(this).val();
        $(this).removeAttr('readonly');
        $(this).closest('td').find('span.c_save, span.c_cancel').show();        
    });
    $('span.c_save').click(function() {
        var td = $(this).closest('td');
        var client = td.find('input.client');
        $.ajax({
            async: true,
            url: "<?php echo $this->Html->url(array('controller' => 'SalesEntry', 'action' => 'mp_change_client', 'admin' => false)); ?>",
            type: "POST",
            data: {'client': client.val(), 'key': client.attr('data-key')},
            success: function (resp) {
                if(resp) {
                    td.text(client.val());
                } else {
                    alert('Client Number not found.');
                }
            }
        });
    });
    $('span.c_cancel').click(function() {
        var td = $(this).closest('td');
        td.find('input').val(original).attr('readonly', true);
        td.find('span').removeAttr('style');
        original = '';
    });
});
</script>